% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{problem-parts}
\alias{problem-parts}
\alias{objective}
\alias{objective<-}
\alias{constraints}
\alias{constraints<-}
\alias{size_metrics}
\title{Parts of a Problem}
\usage{
objective(object)

objective(object) <- value

constraints(object)

constraints(object) <- value

size_metrics(object)
}
\arguments{
\item{object}{A \linkS4class{Problem} object.}

\item{value}{The value to assign to the slot.}
}
\value{
For getter functions, the requested slot of the object.
x <- Variable()
prob <- Problem(Minimize(x^2), list(x >= 5))
objective(prob)
constraints(prob)
size_metrics(prob)

objective(prob) <- Maximize(sqrt(x))
constraints(prob) <- list(x <= 10)
objective(prob)
constraints(prob)
}
\description{
Get and set the objective, constraints, or size metrics (get only) of a problem.
}
