% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{parse_cvek_formula}
\alias{parse_cvek_formula}
\title{Parsing User-supplied Formula}
\usage{
parse_cvek_formula(
  formula,
  kern_func_list,
  data,
  data_new = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{(formula) A user-supplied formula.}

\item{kern_func_list}{(list) A list of kernel functions in the kernel library}

\item{data}{(data.frame, n*d) A data.frame, list or environment (or object
coercible by as.data.frame to a data.frame), containing the variables in
formula. Neither a matrix nor an array will be accepted.}

\item{data_new}{(data.frame, n_new*d) New data for computing predictions.}

\item{verbose}{(logical) Whether to print additional messages.}
}
\value{
A list of three slots:
\item{Y}{(matrix, n*1) The vector of response variable.}
\item{X}{(matrix, n*d_fix) The fixed effect matrix.}
\item{K}{(list of matrices) A nested list of kernel term matrices. 
The first level corresponds to each base kernel function in 
kern_func_list, the second level corresponds to each kernel term
specified in the formula.}
}
\description{
Parsing user-supplied formula to fixed-effect and kernel matrices.
}
\details{
The formula object is exactly like the formula for a GLM except that user can
use k() to specify kernel terms.
Additionally, user can specify interaction between kernel terms (using either '*' and ':'),
and exclude interaction term by including -1 on the RHS of formula.
}
\author{
Jeremiah Zhe Liu
}
