% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inibestcubecsi.R
\name{inibestcubecsi}
\alias{inibestcubecsi}
\title{Preliminary estimates of parameters for CUBE models with covariates only for feeling}
\usage{
inibestcubecsi(m,ordinal,W,starting,maxiter,toler)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of selected covariates to explain the feeling component}

\item{starting}{Starting values for preliminary estimation of a CUBE without covariate}

\item{maxiter}{Maximum number of iterations allowed for preliminary iterations}

\item{toler}{Fixed error tolerance for final estimates for preliminary iterations}
}
\value{
A vector \code{(pai, gamaest, phi)}, where \code{pai} is the initial estimate for the uncertainty parameter, 
\code{gamaest} is the vector of initial estimates for the feeling component (including an intercept term in the first entry),
  and \code{phi} is the initial estimate for the overdispersion parameter.
}
\description{
Compute preliminary parameter estimates of a CUBE model with covariates only for feeling, given
 ordinal responses. These estimates are set as initial values to start the corresponding E-M algorithm within the package.
}
\details{
Preliminary estimates for the uncertainty and the overdispersion parameters are computed by short runs of EM. 
As to the feeling component, it considers the nested CUB model with covariates and calls \code{\link{inibestgama}} to derive initial estimates for the coefficients
  of the selected covariates for feeling.
}
\examples{
data(relgoods)
isnacov<-which(is.na(relgoods$Gender))
isnaord<-which(is.na(relgoods$Tv))
na<-union(isnacov,isnaord)
ordinal<-relgoods$Tv[-na]; W<-relgoods$Gender[-na]
m<-10
starting<-rep(0.1,3)
ini<-inibestcubecsi(m,ordinal,W,starting,maxiter=100,toler=1e-3)
nparam<-length(ini)
pai<-ini[1]                 # Preliminary estimates for uncertainty component
gamaest<-ini[2:(nparam-1)]  # Preliminary estimates for coefficients of feeling covariates
phi<-ini[nparam]            # Preliminary estimates for overdispersion component
}
\seealso{
\code{\link{inibestcube}}, \code{\link{inibestcubecov}}, \code{\link{inibestgama}}
}
\keyword{htest}
\keyword{utilities}
