% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/varcovcubp0.R
\name{varcovcubp0}
\alias{varcovcubp0}
\title{Variance-covariance matrix of CUB model with covariates for the uncertainty parameter}
\usage{
varcovcubp0(m, ordinal, Y, bet, csi)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of covariates for explaining the uncertainty parameter}

\item{bet}{Vector of parameters for the uncertainty component, whose length equals NCOL(Y)+1
to include an intercept term (first entry)}

\item{csi}{Feeling parameter}
}
\description{
Compute the variance-covariance matrix of parameter estimates of a CUB model with
covariates for the uncertainty component.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not,
it returns a warning message and produces a matrix with NA entries.
}
\references{
Piccolo D. (2006), Observed Information Matrix for CUB Models, \emph{Quaderni di Statistica}, \bold{8}, 33--78
}
\seealso{
\code{\link{probcubpq}}
}
\keyword{internal}

