% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Threshold.R
\name{Threshold}
\alias{Threshold}
\title{Absolute value of a relative threshold (percentile)}
\usage{
Threshold(
  data,
  threshold,
  dates = NULL,
  start = NULL,
  end = NULL,
  time_dim = "time",
  memb_dim = "member",
  sdate_dim = "sdate",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{A multidimensional array with named dimensions.}

\item{threshold}{A single scalar or vector indicating the relative 
threshold(s). It must contain values between 0 and 1.}

\item{dates}{A multidimensional array of dates with named dimensions matching 
the temporal dimensions on parameter 'data'. By default it is NULL, to  
select aperiod this parameter must be provided.}

\item{start}{An optional parameter to defined the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the temporal 
dimension. By default, it is set to 'time'. More than one dimension name 
matching the dimensions provided in the object \code{data$data} can be 
specified. This dimension is required to subset the data in a requested 
period.}

\item{memb_dim}{A character string indicating the name of the dimension in 
which the ensemble members are stored. When set it to NULL, threshold is 
computed for individual members.}

\item{sdate_dim}{A character string indicating the name of the dimension in 
which the initialization dates are stored.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A multidimensional array with named dimensions containing the
corresponding values of a percentile in the element \code{data}.
}
\description{
Frequently, thresholds are defined by a percentile that may correspond to a 
different absolute value depending on the variable, gridpoint and also julian 
day (time). This function calculates the corresponding value of a percentile 
given a dataset.
}
\examples{
threshold <- 0.9
data <- array(rnorm(25 * 3 * 214 * 2, mean = 26), 
             c(member = 25, sdate = 3, time = 214, lon = 2)) 
thres_q <- Threshold(data, threshold)
data <- array(rnorm(1 * 3 * 214 * 2), c(member = 1, sdate = 3, time = 214, lon = 2))
res <- Threshold(data, threshold)

}
