% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_circular_colors.R
\name{ch_circular_colors}
\alias{ch_circular_colors}
\title{Color Palettes for Circular}
\usage{
ch_circular_colors(
  n,
  m = 0,
  M = 2 * pi,
  offset = 0,
  s = 0.85,
  v = 0.85,
  alpha = 1
)
}
\arguments{
\item{n}{the number of colours (<= 1) to be in the palette}

\item{m}{the smallest angle in radians}

\item{M}{the largest angle in radians}

\item{offset}{the zero in radians}

\item{s}{saturation further arguments passed to the function hsv}

\item{v}{value [0.85]}

\item{alpha}{alpha [1.0] no transparency}
}
\value{
a vector of length n
}
\description{
Produces a vector of n contiguous colours. The original version from the package
circular produced n colours with 1 and n being the same colour. This version
internally produces n + 1 colours and removes the repeated end colour so there
are n unique colours. Hue is calculated for points on the circle. Saturation  and
value default to 0.85. Default alpha is 1.0 - no transparency.
}
\examples{
ch_circular_colors(n=10)
}
\author{
Claudio Agostinelli (original) Paul Whitfield (update)
}
