% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ch_date_subset}
\alias{ch_date_subset}
\title{Subsets dates by string}
\usage{
ch_date_subset(df, prd)
}
\arguments{
\item{df}{data frame of time series data; includes a variable called \code{Date}}

\item{prd}{date range as string formatted as \option{YYYY-MM-DD/YYYY-MM-DD}}
}
\value{
\item{df}{subsetted data frame}
}
\description{
Subsets a data frame by an specified date range, provided as
a string by the \code{prd} argument. This function is meant to emulate the subsetting
capability of the \pkg{xts} package.
}
\examples{
{
dd <- seq.Date(as.Date("2010-10-01"), as.Date("2013-09-30"), by = 1)
x <- rnorm(length(dd))
y <- abs(rnorm(length(dd)))*2
df <- data.frame("Date" = dd,x,y)
prd <- "2011-10-01/2012-09-30"
summary(ch_date_subset(df,prd))}

}
\author{
Robert Chlumsky
}
\keyword{data}
\keyword{date}
\keyword{subset}
