fixedMetaAnalMD <- function(data, alpha=0.05)
{
if (!is.matrix(data))
	stop("Sorry data must be a matrix of Mean Diff, 95 % Lower and Upper Limits from Previous Studies")

if (ncol(data) != 3)
	stop("Data must have 3 columns, Mean Diff, Lower Limit and Upper Limit from Previous Studies")

if ((alpha >= 1) || (alpha <= 0))
        stop("Sorry, the alpha must lie within (0,1)")

X <- NULL;
X$data <- data; X$alpha <- alpha;

colnames(X$data) <- c("Mean Diff", "Lower Limit", "Upper Limit");

MD <- data[,1];
seMD <- (data[,3] - data[,1])/1.96;
varMD <- seMD^2;
w <- 1/varMD;

Z <- -qnorm(alpha/2)
X$thetaF <- sum(MD*w)/sum(w);
X$uF <- X$thetaF + Z/sqrt(sum(w));
X$lF <- X$thetaF - Z/sqrt(sum(w));
X$Var <- 1/sum(w);

if ( (X$uF < 0) && (X$lF < 0) || (X$uF > 0) && (X$lF > 0) )
{
X$Sig <- 1;
}
else
{
X$Sig <- 0;
}


class(X) <- "fixedMetaAnalCTS";
return(X);
}


#Print method
print.fixedMetaAnalMD <- function(x, ...)
{
cat("The Fixed Effects Mean Difference: ", x$thetaF, "\n", sep="");
cat("With ", (1 - x$alpha)*100,  "% Confidence Limits: (", x$lF, ", ", x$uF,")", sep="");
}

#Summary Method
summary.fixedMetaAnalMD <- function(object, ...)
{
cat("Original Data Matrix:", "\n \n", sep="")
print(object$data)
cat("\n")
cat("The Fixed Effects Mean Difference is: ", object$thetaF, "\n", sep="");
cat("With ", (1 - object$alpha)*100,  "% Confidence Limits: (", object$lF, ", ", object$uF, ") \n \n",sep="");
if (object$Sig == 1)
{
cat("This result is statistically significant at the 5 percent level.", sep="");
}
if (object$Sig == 0)
{
cat("This result is not statistically significant at the 5 percent level.", sep="");
}
}