% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iokm.R
\name{iokm}
\alias{iokm}
\title{Interval okm clustering.}
\usage{
iokm(x, centers, nstart = 10, distance = "euclid", algorithm = "std",
  update = "mean", trace = FALSE, iter.max = 20, secure = FALSE)
}
\arguments{
\item{x}{An 3D interval array.}

\item{centers}{A number or interval, number of cluster for clustering or pre init centers.}

\item{nstart}{A number, number of execution to find the best result.}

\item{distance}{A string ('euclid': Euclidian distance, 'hausdorff': Hausdorff distance).}

\item{algorithm}{A string ('std': Standard algorithm, 'matrix': Matrix algorithm).}

\item{update}{A string ('mean': Mean center, 'sum': Sum center, 'join': Union center, 'meet': Intersect center).}

\item{trace}{A boolean, tracing information on the progress of the algorithm is produced.}

\item{iter.max}{the maximum number of iterations allowed.}

\item{secure}{A boolean (secure interval or not : min <= max).}
}
\description{
Culster interval data with okm algorithm.
}
\examples{
iokm(iaggregate(iris, col=5), 2)
iokm(iaggregate(iris, col=5), iaggregate(iris, col=5))
}
