% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitilde_compute.R
\name{pitilde_compute}
\alias{pitilde_compute}
\title{Compute Conditional Probability of Each Second-Stage Observed Outcome Given Each True Outcome and First-Stage Observed Outcome, for Every Subject}
\usage{
pitilde_compute(delta, V, n, n_cat)
}
\arguments{
\item{delta}{A numeric array of regression parameters for the second-stage observed
outcome mechanism, \eqn{\tilde{Y} | Y^*, Y}
(second-stage observed outcome, given the first-stage observed outcome and the true outcome) ~ \code{V} (misclassification
predictor matrix). Rows of the matrix correspond to parameters for the \eqn{\tilde{Y} = 1}
observed outcome, with the dimensions of \code{V}.
Columns of the matrix correspond to the first-stage observed outcome categories
\eqn{k = 1, \dots,} \code{n_cat}. The third dimension of the array
corresponds to the true outcome categories \eqn{j = 1, \dots,} \code{n_cat}}

\item{V}{A numeric design matrix.}

\item{n}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{V}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcomes can take.}
}
\value{
\code{pitilde_compute} returns an array of conditional probabilities,
\eqn{P(\tilde{Y}_i = \ell | Y^*_i = k, Y_i = j, V_i) = \frac{\text{exp}\{\delta_{\ell kj0} + \delta_{\ell kjV} V_i\}}{1 + \text{exp}\{\delta_{\ell kj0} + \delta_{\ell kjV} V_i\}}}
for each of the \eqn{i = 1, \dots,} \code{n} subjects. Rows of the matrix
correspond to each subject and second-stage observed outcome. Specifically, the probability
for subject \eqn{i} and observed category $1$ occurs at row \eqn{i}. The probability
for subject \eqn{i} and observed category $2$ occurs at row \eqn{i +} \code{n}.
Columns of the matrix correspond to the first-stage outcome categories, \eqn{k = 1, \dots,} \code{n_cat}.
The third dimension of the array corresponds to the true outcome categories,
\eqn{j = 1, \dots,} \code{n_cat}.
}
\description{
Compute Conditional Probability of Each Second-Stage Observed Outcome Given Each True Outcome and First-Stage Observed Outcome, for Every Subject
}
