## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE)

library(kableExtra)

## -----------------------------------------------------------------------------
Term <- c("$X$", "$Z$", "V",
          "$Y$", "$y_{ij}$", "$Y^*$", "$y^*_{ik}$", "$\\tilde{Y}$", "$\\tilde{y}_{i \\ell}$",
          "True Outcome Mechanism", "First-Stage Observation Mechanism",
          "Second-Stage Observation Mechanism",
          "$\\pi_{ij}$", "$\\pi^*_{ikj}$", "$\\tilde{\\pi}_{i \\ell kj}$",
          "$\\pi^*_{ik}$", "$\\pi^*_{jj}$", "$\\tilde{\\pi}_{jjj}$",
          "First-Stage Sensitivity", "Second-Stage Specificity",
          "$\\beta_X$", "$\\gamma_{11Z}$", "$\\gamma_{12Z}$",
          "$\\delta_{111Z}$", "$\\delta_{121Z}$", "$\\delta_{112Z}$", "$\\delta_{122Z}$")
Definition <- c("--", "--", "--",
                "$Y \\in \\{1, 2\\}$", "$\\mathbb{I}\\{Y_i = j\\}$",
                "$Y^* \\in \\{1, 2\\}$", "$\\mathbb{I}\\{Y^*_i = k\\}$",
                "$\\tilde{Y} \\in \\{1, 2\\}$", "$\\mathbb{I}\\{\\tilde{Y}_i = \\ell \\}$",
                "$\\text{logit} \\{ P(Y = j | X ; \\beta) \\} = \\beta_{j0} + \\beta_{jX} X$",
                "$\\text{logit}\\{ P(Y^* = k | Y = j, Z ; \\gamma) \\} = \\gamma_{kj0} + \\gamma_{kjZ} Z$",
                "$\\text{logit}\\{ P(\\tilde{Y} = \\ell | Y^* = k, Y = j, V ; \\delta) \\} = \\delta_{\\ell kj0} + \\delta_{\\ell kjV} V$",
                "$P(Y_i = j | X ; \\beta) = \\frac{\\text{exp}\\{\\beta_{j0} + \\beta_{jX} X_i\\}}{1 + \\text{exp}\\{\\beta_{j0} + \\beta_{jX} X_i\\}}$",
                "$P(Y^*_i = k | Y_i = j, Z ; \\gamma) = \\frac{\\text{exp}\\{\\gamma_{kj0} + \\gamma_{kjZ} Z_i\\}}{1 + \\text{exp}\\{\\gamma_{kj0} + \\gamma_{kjZ} Z_i\\}}$",
                "$P(\\tilde{Y}_i = \\ell | Y^*_i = k, Y_i = j, Z ; \\delta) = \\frac{\\text{exp}\\{\\delta_{\\ell kj0} + \\delta_{\\ell kjV} V_i\\}}{1 + \\text{exp}\\{\\delta_{\\ell kj0} + \\delta_{\\ell kjV} V_i\\}}$",
                "$P(Y^*_i = k | Y_i, X, Z ; \\gamma) = \\sum_{j = 1}^2 \\pi^*_{ikj} \\pi_{ij}$",
                "$P(Y^* = j | Y = j, Z ; \\gamma) = \\sum_{i = 1}^N \\pi^*_{ijj}$",
                "$P(\\tilde{Y} = j | Y^* = j, Y = j, Z ; \\delta) = \\sum_{i = 1}^N \\tilde{\\pi}_{ijjj}$",
                "$P(Y^* = 1 | Y = 1, Z ; \\gamma) = \\sum_{i = 1}^N \\pi^*_{i11}$",
                "$P(Y^* = 2 | Y = 2, Z ; \\gamma) = \\sum_{i = 1}^N \\pi^*_{i22}$",
                "--", "--", "--", "--", "--", "--", "--")
Description <- c("Predictor matrix for the true outcome.",
                 "Predictor matrix for the first-stage observed outcome, conditional on the true outcome.",
                 "Predictor matrix for the second-stage observed outcome, conditional on the true outcome and first-stage observed outcome.",
                 "True binary outcome. Reference category is 2.",
                 "Indicator for the true binary outcome.",
                 "First-stage observed binary outcome. Reference category is 2.",
                 "Indicator for the first-stage observed binary outcome.",
                 "Second-stage observed binary outcome. Reference category is 2.",
                 "Indicator for the second-stage observed binary outcome.",
                 "Relationship between $X$ and the true outcome, $Y$.",
                 "Relationship between $Z$ and the first-stage observed outcome, $Y^*$, given the true outcome $Y$.",
                 "Relationship between $V$ and the second-stage observed outcome, $\\tilde{Y}$, given the first-stage observed outcome, $Y^*$, and the true outcome $Y$.",
                 "Response probability for individual $i$'s true outcome category.",
                 "Response probability for individual $i$'s first-stage observed outcome category, conditional on the true outcome.",
                 "Response probability for individual $i$'s second-stage observed outcome category, conditional on the first-stage observed outcome and the true outcome.",
                 "Response probability for individual $i$'s first-stage observed outcome cateogry.",
                 "Average probability of first-stage correct classification for category $j$.",
                 "Average probability of first-stage and second-stage correct classification for category $j$.",
                 "True positive rate. Average probability of observing outcome $k = 1$, given the true outcome $j = 1$.",
                 "True negative rate. Average probability of observing outcome $k = 2$, given the true outcome $j = 2$.",
                 "Association parameter of interest in the true outcome mechanism.",
                 "Association parameter of interest in the first-stage observation mechanism, given $j=1$.",
                 "Association parameter of interest in the first-stage observation mechanism, given $j=2$.",
                 "Association parameter of interest in the second-stage observation mechanism, given $k = 1$ and $j = 1$.",
                 "Association parameter of interest in the second-stage observation mechanism, given $k = 2$ and $j = 1$.",
                 "Association parameter of interest in the second-stage observation mechanism, given $k = 1$ and $j = 2$.",
                 "Association parameter of interest in the second-stage observation mechanism, given $k = 2$ and $j = 2$.")

notation_table <- data.frame(Term, Definition, Description)

## -----------------------------------------------------------------------------
kableExtra::kbl(notation_table, escape = FALSE, booktabs = TRUE) %>%
  kableExtra::kable_styling(latex_options = "HOLD_position")

