% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{n_dist2max}
\alias{n_dist2max}
\title{Normalise as distance to maximum value}
\usage{
n_dist2max(x)
}
\arguments{
\item{x}{A numeric vector}
}
\value{
Numeric vector
}
\description{
A measure of the distance to the maximum value, where the maximum value is the highest-scoring value. The
formula used is:
}
\details{
\deqn{ 1 - (x_{max} - x)/(x_{max} - x_{min}) }

This means that the closer a value is to the maximum, the higher its score will be. Scores will be in the
range of 0 to 1.
}
\examples{
x <- runif(20)
n_dist2max(x)

}
