% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_coins_multi}
\alias{compare_coins_multi}
\title{Compare multiple coins}
\usage{
compare_coins_multi(
  coins,
  dset,
  iCode,
  also_get = NULL,
  tabtype = "Values",
  ibase = 1,
  sort_table = TRUE,
  compare_by = "ranks"
)
}
\arguments{
\item{coins}{A list of coins. If names are provided, these will be used in the tables returned by this function.}

\item{dset}{The name of a data set found in \code{.$Data}. See \code{\link[=get_data]{get_data()}}.}

\item{iCode}{A column name of the data set targeted by \code{dset}. See \code{\link[=get_data]{get_data()}}.}

\item{also_get}{Optional metadata columns to attach to the table: see \code{\link[=get_data]{get_data()}}. If this is not specified, the
results of each coin will be merged using the \code{uCode}s within each coin. If this is specified, results will be
merged additionally using the metadata columns. This means that coins must share the same metadata columns that
are returned as a result of \code{also_get}.}

\item{tabtype}{The type of table to generate. One of:
\itemize{
\item \code{"Ranks"}: returns a data frame of index ranks for each coin provided, plus ISO3 column
\item \code{"Diffs"}: returns a data frame of index rank differences between the base coin and each other coin (see \code{ibase})
\item \code{"AbsDiffs"}: as \code{"Diffs"} but absolute rank differences are returned
\item \code{"All"}: returns all of the three previous rank tables, as a list of data frames
}}

\item{ibase}{The index of the coin to use as a base comparison (default first coin in list)}

\item{sort_table}{If TRUE, sorts by the base COIN (\code{ibase}) (default).}

\item{compare_by}{Either \code{"ranks"} which produces a comparison using ranks, or else \code{"scores"}, which instead
uses scores. Note that scores may be very different if the methodology is different from one coin to another,
e.g. for different normalisation methods.}
}
\value{
Data frame unless \code{tabtype = "All"}, in which case a list of three data frames is returned.
}
\description{
Given multiple coins as a list, generates a rank comparison of a single indicator or aggregate which is specified
by the \code{dset} and \code{iCode} arguments (passed to \code{\link[=get_data]{get_data()}}). The indicator or aggregate targeted must be available
in all the coins in \code{coins}.
}
\details{
By default, the ranks of the target indicator/aggregate of each coin will be merged using the \code{uCode}s within each coin.
Optionally, specifying \code{also_get} (passed to \code{\link[=get_data]{get_data()}}) will additionally merge using the metadata columns.
This means that coins must share the same metadata columns that are returned as a result of \code{also_get}.
}
\examples{
# see vignette("adjustments")

}
