% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{build_example_coin}
\alias{build_example_coin}
\title{Build ASEM example coin}
\usage{
build_example_coin(up_to = NULL, quietly = FALSE)
}
\arguments{
\item{up_to}{The point up to which to build the index. If \code{NULL}, builds full index. Else specify a building function
(as a string) - the index will be built up to and including this function. This option is mainly for helping with
function examples. Example: \code{up_to = "Normalise"}.}

\item{quietly}{If \code{TRUE}, suppresses all messages.}
}
\value{
coin class object
}
\description{
Shortcut function to build the ASEM example coin, using inbuilt example data. This can be useful for testing and also
for building reproducible examples. To see the underlying commands run \code{edit(build_example_coin)}. See also
\code{vignette("coins")}.
}
\examples{
# build example coin up to data treatment step
coin <- build_example_coin(up_to = "Treat")
coin

}
