% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{Aggregate.purse}
\alias{Aggregate.purse}
\title{Aggregate indicators}
\usage{
\method{Aggregate}{purse}(
  x,
  dset,
  f_ag = NULL,
  w = NULL,
  f_ag_para = NULL,
  dat_thresh = NULL,
  write_to = NULL,
  ...
)
}
\arguments{
\item{x}{A purse-class object}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{f_ag}{The name of an aggregation function, specified as a string}

\item{w}{An optional data frame of weights. If \code{f_ag} does not require or accept weights, set to \code{"none"}.}

\item{f_ag_para}{Optional parameters to pass to \code{f_ag}, other than \code{x} and \code{w}}

\item{dat_thresh}{An optional data availability threshold, specified as a number between 0 and 1. If a row
within an aggregation group has data availability lower than this threshold, the aggregated value for that row will be
\code{NA}. Data availability, for a row \code{x_row} is defined as \code{sum(!is.na(x_row))/length(x_row)}, i.e. the
fraction of non-\code{NA} values.}

\item{write_to}{If specified, writes the aggregated data to \code{.$Data[[write_to]]}. Default \code{write_to = "Aggregated"}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated purse with new treated data sets added at \code{.$Data[[write_to]]} in each coin.
}
\description{
Aggregates indicators following the structure specified in \code{iMeta}, for each coin inside the purse.
See \code{\link[=Aggregate.coin]{Aggregate.coin()}} for more information.
}
\examples{
# build example purse up to normalised data set
purse <- build_example_purse(up_to = "Normalise", quietly = TRUE)

# aggregate using defaults
purse <- Aggregate(purse, dset = "Normalised")

}
