% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinToolIn.R
\name{COINToolIn}
\alias{COINToolIn}
\title{Import data directly from COIN Tool}
\usage{
COINToolIn(fname, makecodes = FALSE, oldtool = FALSE)
}
\arguments{
\item{fname}{The file name and path to read, e.g. \code{"C:/Documents/COINToolFile.xlsx"}.}

\item{makecodes}{Logical: if \code{TRUE}, will generate short indicator codes based on indicator names,
otherwise if \code{FALSE}, will use COIN Tool indicator codes \code{"Ind.01"}, etc. Currently only does this
for indicators, not aggregation groups.}

\item{oldtool}{Logical: if \code{TRUE}, compatible with old COIN Tool (pre-release, early 2019 or earlier).
There are some minor differences on where the elements are found.}
}
\value{
A list containing:
\itemize{
\item \code{.$IndData} A data frame of imported indicator data to be input as the \code{IndData} argument in \code{\link[=assemble]{assemble()}}.
\item \code{.$IndMeta} A data frame of imported indicator metadata to be input as the \code{IndMeta} argument in \code{\link[=assemble]{assemble()}}.
\item \code{.$AggMeta} A data frame of imported aggregation metadata to be input as the \code{AggMeta} argument in \code{\link[=assemble]{assemble()}}.
}
}
\description{
This provides a direct interface for reading a COIN Tool input deck and converting it to COINr.
You need to provide a COIN Tool file, with the "Database" sheet properly compiled.
}
\details{
The \href{https://knowledge4policy.ec.europa.eu/composite-indicators/coin-tool_en}{COIN Tool} is an Excel-based tool for building composite indicators.

See \href{https://bluefoxr.github.io/COINrDoc/helper-functions.html#r-interfaces}{COINr online documentation} for more details and an example.
}
\examples{
\dontrun{
## This example downloads a COIN Tool spreadsheet containing example data,
## saves it to a temporary directory, unzips, and reads into R. Finally it
## assembles it into a COIN.

# Make temp zip filename in temporary directory
tmpz <- tempfile(fileext = ".zip")
# Download an example COIN Tool file to temporary directory
# NOTE: the download.file() command may need its "method" option set to a
# specific value depending on the platform you run this on. You can also
# choose to download/unzip this file manually.
download.file("https://knowledge4policy.ec.europa.eu/sites/default/
files/coin_tool_v1_lite_exampledata.zip", tmpz)
# Unzip
CTpath <- unzip(tmpz, exdir = tempdir())
# Read COIN Tool into R
l <- COINToolIn(CTpath, makecodes = TRUE)
# We can finish by assembling it
CT_exampleCOIN <- assemble(l$IndData, l$IndMeta, l$AggMeta)
}

}
\seealso{
\itemize{
\item \code{\link[=coin2Excel]{coin2Excel()}} Export COIN contents to Excel
}
}
