% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinToolIn.R
\name{names2Codes}
\alias{names2Codes}
\title{Generate short codes from long names}
\usage{
names2Codes(cvec, maxword = 2, maxlet = 4)
}
\arguments{
\item{cvec}{A character vector of names}

\item{maxword}{The maximum number of words to use in building a short name (default 2)}

\item{maxlet}{The number of letters to take from each word (default 4)}
}
\value{
A corresponding character vector, but with short codes, and no duplicates.
}
\description{
Given a character vector of long names (probably with spaces), generates short codes.
Intended for use when importing from the COIN Tool.
}
\examples{
# generate codes for indicators in the ASEM data set (first five only)
names2Codes(ASEMIndMeta$IndName[1:5], maxlet = 3)

}
\seealso{
\itemize{
\item \code{\link[=COINToolIn]{COINToolIn()}} Import data from the COIN Tool (Excel).
}
}
