% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAsymmetricBlockIndices.R
\name{getAsymmetricBlockIndices}
\alias{getAsymmetricBlockIndices}
\title{Get Block Indices from an asymmetric (or symmetric) matrix.}
\usage{
getAsymmetricBlockIndices(
  genomicmatrix = NULL,
  algorithm = "HiCseg",
  nb_change_max = 100,
  distrib = "G",
  model = "D",
  MI_strategy = "average",
  transpose = T
)
}
\arguments{
\item{genomicmatrix}{the large, whole matrix from which blocks are taken}

\item{algorithm}{Algorithm to be used: HiCseg or jointSeg.}

\item{nb_change_max}{the maximal number of changepoints, passed to HiCseg (if this algorithm is used). Note: HiCseg doesn't actually obey this limit. Rather, use it as a parameter to increase/decrease segmentation extent.}

\item{distrib}{Passed to Hicseg_linkC_R, from their documentation: Distribution of the data: "B" is for Negative Binomial distribution, "P" is for the Poisson distribution and "G" is for the Gaussian distribution."}

\item{model}{Passed on to HiCseg_linkC_R: "Type of model: "D" for block-diagonal and "Dplus" for the extended block-diagonal model."}

\item{MI_strategy}{strategy to make the matrix temporarily symmetric. "average" adds a number of values equal to the average of the matrix, while copy copies part of the matrix to the shorter side, making a square matrix.}

\item{transpose}{transpose the matrix and output the breakpoints? Some segmentation algorithms (e.g. HiCseg) produces different results when used against the transposed version of the matrix, as it expects symmetry. This allows the output of additional breakpoints Users can choose to take intersect() or union() on the results to get conserved changepoints or additional changepoints, depending on need.}
}
\value{
An output list of the following:

breakpoints_col A vector of breakpoints for the columns.

breakpoints_row A vector of breakpoints for the rows.

breakpoints_col A vector of breakpoints for columns on the transposed genomic matrix.

breakpoints_row A vector of breakpoints for the rows on the transposed genomic matrix.
}
\description{
This function segments a matrix, including asymmetric matrices using multiple imputation (MI) techniques and a segmentation algorithm to generate breakpoints for column and row.
}
\examples{

load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope")) 
submatrix_tiny<-nbl_result_matrix_sign_small
tiny_test<-getAsymmetricBlockIndices(submatrix_tiny)
\dontrun{
submatrix_wide<-submatrix_tiny[1:5,]
submatrix_narrow<-submatrix_tiny[,1:5]
wide_test<-getAsymmetricBlockIndices(submatrix_wide,distrib = "G",model = "Dplus",
 nb_change_max = 1e4)
 #the below work, but the time to run all of these would be greater than 10 seconds..
random_wide<-matrix(runif(n = 400*200),ncol=400,nrow=200)
random_narrow<-matrix(runif(n = 400*200),ncol=200,nrow=400)
random_wide_test_avg<-getAsymmetricBlockIndices(random_wide,
 distrib = "G",model = "Dplus",nb_change_max = 1e4)
random_narrow_test_avg<-getAsymmetricBlockIndices(random_narrow,
 distrib = "G",model = "Dplus",nb_change_max = 1e4)
random_wide_test_copy<-getAsymmetricBlockIndices(random_wide,
 distrib = "G",model = "Dplus",nb_change_max = 1e4,MI_strategy = "copy")
random_narrow_test_copy<-getAsymmetricBlockIndices(random_narrow,
 distrib = "G",model = "Dplus",nb_change_max = 1e4,MI_strategy = "copy")
genomicmatrix=random_narrow
nb_change_max=100
model = "D"
distrib = "G"
MI_strategy="copy"
#question-- does it pick different breakpoints if transposed first?
#Answer: yes, at least in Dplus model.
rm(genomicmatrix)
rm(model)
rm(distrib)
rm(MI_strategy)
random_wide_test_copy<-getAsymmetricBlockIndices(genomicmatrix = random_wide,
                                                 distrib = "G",
                                     model = "Dplus",nb_change_max = 1e2,MI_strategy = "copy")
random_narrow_test_copy<-getAsymmetricBlockIndices(random_narrow,distrib = "G",
                                                   model = "Dplus",
                                                   nb_change_max = 1e2,MI_strategy = "copy")
random_wide_test_copy_t<-getAsymmetricBlockIndices(genomicmatrix = t(random_wide),
                                                  distrib = "G",model = "Dplus",
                                                  nb_change_max = 1e2,MI_strategy = "copy")
random_narrow_test_copy_t<-getAsymmetricBlockIndices(genomicmatrix = t(random_narrow),
                                                    distrib = "G",model = "Dplus",
                                                    nb_change_max = 1e2,MI_strategy = "copy")
length(intersect(random_wide_test_copy$breakpoints_col,
random_wide_test_copy_t$breakpoints_row))/length(unique(c(random_wide_test_copy$breakpoints_col,
random_wide_test_copy_t$breakpoints_row)))
random_wide_test_copy_with_transpose<-getAsymmetricBlockIndices(genomicmatrix = random_wide,
 distrib = "G",model = "Dplus",nb_change_max = 1e2,MI_strategy = "copy",transpose = T)
random_narrow_test_copy_with_transpose<-getAsymmetricBlockIndices(genomicmatrix = random_narrow,
 distrib = "G",model = "Dplus",nb_change_max = 1e2,MI_strategy = "copy",transpose = T)
random_narrow_test_copy_with_transpose<-getAsymmetricBlockIndices(genomicmatrix = random_narrow,
 distrib = "G",model = "Dplus",nb_change_max = 1e2,MI_strategy = "copy",transpose = T)
conserved_breakpoints_col<-intersect(random_narrow_test_copy_with_transpose$breakpoints_col,
 random_narrow_test_copy_with_transpose$t_breakpoints_row)
conserved_breakpoints_row<-intersect(random_narrow_test_copy_with_transpose$breakpoints_row,
 random_narrow_test_copy_with_transpose$t_breakpoints_col)
random_wide_test_copy_with_transpose<-getAsymmetricBlockIndices(genomicmatrix = random_wide,
 distrib = "G",model = "Dplus",nb_change_max = 1e2,MI_strategy = "copy",transpose = T)
conserved_breakpoints_col<-intersect(random_wide_test_copy_with_transpose$breakpoints_col,
 random_wide_test_copy_with_transpose$t_breakpoints_row)
conserved_breakpoints_row<-intersect(random_wide_test_copy_with_transpose$breakpoints_row,
 random_wide_test_copy_with_transpose$t_breakpoints_col)
}
}
\keyword{CNV}
\keyword{Hi-C}
\keyword{HiCseg}
\keyword{MI}
\keyword{breakpoints}
\keyword{imputation}
\keyword{jointseg}
\keyword{multiple}
