% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_factor_sub.R
\name{location_factor_sub}
\alias{location_factor_sub}
\title{Location Factor (Excl.Submarine Cables)}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
location_factor_sub(
  topography = "Default",
  situation = "Default",
  wind_wave = "Default",
  intensity = "Default",
  landlocked = "no"
)
}
\arguments{
\item{topography}{String. Describe the topography around the submarine cable.
Options:
\code{typography = c("Low Detrimental Topography",
"Medium Detrimental Topography", "High Detrimental Topography",
"Very High Detrimental Topography","Default" )}}

\item{situation}{String. Descibes how the submarine cable af fixed to the
sea floor.
Options:
\code{sitution=c("Laid on bed", "Covered", "Buried", "Default")}}

\item{wind_wave}{Numeric.
Options:
\code{wind_wave=c(1, 2, 3, "Default")}.
Settings:
\itemize{
\item{\code{wind_wave = 1}:} Sheltered sea loch, Wind <200 W/m2
\item{\code{wind_wave = 2}:} Wave <15kW/m, Wind 200-800 W/m2
\item{\code{wind_wave = 3}:} Wave <15kW/m, Wind 200-800 W/m2
\item{\code{wind_wave = "Default"}:} No data available
}}

\item{intensity}{String. Combined wave and current energy factor.
Options:
\code{intensity=c("Low", "Moderate", "High", "Default")}.}

\item{landlocked}{String. Options: \code{landlocked = c("yes","no")}. Default
setting for \code{landlocked = "no"}.}
}
\value{
Numeric. Location factor
}
\description{
This function calculates the location factor for
submarine cables based in the specific location of the cable.
See section 6.5 on page 48 in CNAIM (2021). For calculating the location
factor for all other network assets please see the function
\code{\link{location_factor}()}.
}
\examples{
 # Location factor for a non-landlocked submarine cable
location_factor_sub(topography = "Default",
                    situation = "Default",
                    wind_wave = "Default",
                    intensity = "Default",
                    landlocked = "no")
}
