% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{AIC.clme}
\alias{AIC.clme}
\alias{AIC.summary.clme}
\title{Akaike information criterion}
\usage{
\method{AIC}{clme}(object, ..., k = 2)

\method{AIC}{summary.clme}(object, ..., k = 2)
}
\arguments{
\item{object}{object of class \code{\link{clme}}.}

\item{...}{space for additional arguments.}

\item{k}{value multiplied by number of coefficients}
}
\value{
Returns the information criterion (numeric).
}
\description{
Calculates the Akaike and Bayesian information criterion for objects of class \code{clme}.

Calculates the Akaike and Bayesian information criterion for objects of class \code{clme}.
}
\details{
The log-likelihood is assumed to be the Normal distribution. The model uses residual bootstrap methodology, and Normality is neither required nor assumed. Therefore the log-likelihood and these information criterion may not be useful measures for comparing models.
For \code{k=2}, the function computes the AIC. To obtain BIC, set \eqn{k = log( n/(2*pi) )}; which the method \code{BIC.clme} does.
}
\examples{

data( rat.blood )

cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 0)

AIC( clme.out )
AIC( clme.out, k=log( nobs(clme.out)/(2*pi) ) )


}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}

\code{\link{CLME-package}}
\code{\link{clme}}
}
