% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/minque.r
\name{minque}
\alias{minque}
\title{MINQUE Algorithm}
\usage{
minque(Y, X1, X2 = NULL, U = NULL, Nks = dim(X1)[1], Qs = dim(U)[2],
  mq.eps = 1e-04, mq.iter = 500, verbose = FALSE, ...)
}
\arguments{
\item{Y}{\eqn{N \times 1}{Nx1} vector of response data.}

\item{X1}{\eqn{N \times p_1}{Nxp1} design matrix.}

\item{X2}{optional \eqn{N \times p_2}{Nxp2} matrix of covariates.}

\item{U}{optional \eqn{N \times c}{Nxc} matrix of random effects.}

\item{Nks}{optional \eqn{K \times 1}{Kx1} vector of group sizes.}

\item{Qs}{optional \eqn{Q \times 1}{Qx1} vector of group sizes for random effects.}

\item{mq.eps}{criterion for convergence for the MINQUE algorithm.}

\item{mq.iter}{maximum number of iterations permitted for the MINQUE algorithm.}

\item{verbose}{if \code{TRUE}, function prints messages on progress of the MINQUE algorithm.}

\item{...}{space for additional arguments.}
}
\value{
The function returns a vector of the form \eqn{(\tau^{2}_{1}, \tau^{2}_{2}, \ldots, \tau^{2}_{q}, \sigma^{2}_{1},\sigma^{2}_{2},\ldots, \sigma^{2}_{k})'}{(tau1^2, tau2^2, \ldots, tauq^2, sigma1^2,sigma2^2,\ldots, sigmak^2)'}. If there are no random effects, then the output is just \eqn{(\sigma^{2}_{1},\sigma^{2}_{2},\ldots, \sigma^{2}_{k})'}{(sigma1^2,sigma2^2,\ldots, sigmak^2)'}.
}
\description{
Algorithm to obtain MINQUE estimates of variance components of a linear mixed effects model.
}
\details{
By default, the model assumes homogeneity of variances for both the residuals and the random effects
 (if included). See the Details in \code{\link{clme_em}} for more information on how to use the
 arguments \code{Nks} and \code{Qs} to permit heterogeneous variances.
}
\note{
This function is called by several other function in \pkg{CLME} to obtain estimates of the random effect variances. If there are no random effects, they will not call \code{minque}.
}
\examples{
data( rat.blood )

model_mats <- model_terms_clme( mcv ~ time + temp + sex + (1|id) ,
                                data = rat.blood )
Y  <- model_mats$Y
X1 <- model_mats$X1
X2 <- model_mats$X2
U  <- model_mats$U

# No covariates or random effects
minque(Y = Y, X1 = X1 )

# Include covariates and random effects
minque(Y = Y, X1 = X1, X2 = X2, U = U )
}

