% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHMM_EM.R
\name{CHMM_EM}
\alias{CHMM_EM}
\title{Perform exact inference of coupled hidden markov models.}
\usage{
CHMM_EM(X, nb.states, S, omega, meth.init = "mclust", var.equal = TRUE,
  itmax = 500, threshold = 1e-07)
}
\arguments{
\item{X}{a data matrix of observations. Columns correspond to individuals.}

\item{nb.states}{a integer specifying the numbers of states.}

\item{S}{a matrix of similarity between individuals.}

\item{omega}{a value of omega.}

\item{meth.init}{a string specifying the initialization method ("mclust" or "kmeans"). The default method is "mclust".}

\item{var.equal}{a logical variable indicating whether to treat the variances as being equal.}

\item{itmax}{an integer specifying the maximal number of iterations for the EM algorithm.}

\item{threshold}{a value for the threshold used for the stopping criteria.}
}
\value{
a list of 10 components
\describe{
\item{\code{postPr}}{a list containing for each series the posterior probabilities.}
\item{\code{initGb}}{a numeric specifying the initial state probabilities.}
\item{\code{transGb}}{a matrix of the state transition probabilities.}
\item{\code{emisGb}}{a list containing for each series the emission probabilities.}
\item{\code{esAvg}}{ a numeric of the estimated mean for each state.}
\item{\code{esVar}}{ a numeric of the estimated variance for each state.}
\item{\code{ID.K}}{ a matrix containing all combination of possible state for nbI series.}
\item{\code{loglik}}{ a numeric with the value of the loglikelihood.}
\item{\code{RSS}}{ a numeric corresponding to the Residuals Sum of Squares.}
\item{\code{iterstop}}{ an integer corresponding to the total number of iterations.}
}
}
\description{
Perform exact inference of coupled hidden markov models.
}
\references{
Wang, X., Lebarbier, E., Aubert, J. and Robin, S., Variational inference for coupled Hidden Markov Models applied to the joint detection of copy number variations.
}
