% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationLex}
\alias{distancePermutationLex}
\title{Lexicographic permutation distance}
\usage{
distancePermutationLex(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
This function calculates the lexicographic permutation distance. That is the difference of positions
that both positions would receive in a lexicographic ordering. Note, that this distance
measure can quickly become inaccurate if the length of the permutations grows too large, due
to being based on the factorial of the length. In general, permutations longer than 100 elements should
be avoided.
}
\examples{
x <- 1:5
y <- c(1,2,3,5,4)
distancePermutationLex(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationLex)

}
\seealso{
\code{\link{lexicographicPermutationOrderNumber}}
}

