% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distanceBasedLandscapeGenerators.R
\name{landscapeGeneratorMUL}
\alias{landscapeGeneratorMUL}
\title{Multimodal Fitness Landscape}
\usage{
landscapeGeneratorMUL(ref = list(1:10), distanceFunction)
}
\arguments{
\item{ref}{list of reference individuals}

\item{distanceFunction}{Distance function, used to evaluate d(x,ref[[n]]), where x is an arbitrary new individual}
}
\value{
returns a function. The function requires a list of candidate solutions as its input, where each solution is suitable for use with the distance function. The function returns a numeric vector.
}
\description{
This function generates multi-modal fitness landscapes based on distance measures.
The fitness is the minimal distance to several reference individuals. Hence, each reference individual
is an optimum of the landscape.
}
\examples{
fun <- landscapeGeneratorMUL(ref=list(1:7,c(2,4,1,5,3,7,6)),distancePermutationCos)
x <- 1:7
fun(list(x))
x <- c(2,4,1,5,3,7,6)
fun(list(x))
x <- 7:1
fun(list(x))
x <- sample(7)
fun(list(x))
## multiple solutions at once:
x <- append(list(1:7,c(2,4,1,5,3,7,6)),replicate(5,sample(7),FALSE))
fun(x)
}
\seealso{
\code{\link{landscapeGeneratorUNI}}, \code{\link{landscapeGeneratorGaussian}}
}

