% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDatanet.R
\docType{package}
\name{CDatanet-package}
\alias{CDatanet}
\alias{CDatanet-package}
\title{The CDatanet package}
\description{
The \pkg{CDatanet} package simulates and estimates peer effect models and network formation models. The class of peer effect models includes linear-in-means models (Lee, 2004; Lee et al., 2010),
Tobit models (Xu and Lee, 2015), and discrete numerical data models (Houndetoungan, 2024).
The network formation models include pair-wise regressions with degree heterogeneity (Graham, 2017; Yan et al., 2019) and exponential random graph models (Mele, 2017).
To make the computations faster \pkg{CDatanet} uses \code{C++} through the \pkg{Rcpp} package (Eddelbuettel et al., 2011).
}
\references{
Eddelbuettel, D., & Francois, R. (2011). \pkg{Rcpp}: Seamless \R and \code{C++} integration. \emph{Journal of Statistical Software}, 40(8), 1-18, \doi{10.18637/jss.v040.i08}.

Houndetoungan, E. A. (2024). Count Data Models with Social Interactions under Rational Expectations. Available at SSRN 3721250, \doi{10.2139/ssrn.3721250}.

Lee, L. F. (2004). Asymptotic distributions of quasi-maximum likelihood estimators for spatial autoregressive models. \emph{Econometrica}, 72(6), 1899-1925, \doi{10.1111/j.1468-0262.2004.00558.x}.

Lee, L. F., Liu, X., & Lin, X. (2010). Specification and estimation of social interaction models with network structures. The Econometrics Journal, 13(2), 145-176, \doi{10.1111/j.1368-423X.2010.00310.x}

Xu, X., & Lee, L. F. (2015). Maximum likelihood estimation of a spatial autoregressive Tobit model. \emph{Journal of Econometrics}, 188(1), 264-280, \doi{10.1016/j.jeconom.2015.05.004}.

Graham, B. S. (2017). An econometric model of network formation with degree heterogeneity. \emph{Econometrica}, 85(4), 1033-1063, \doi{10.3982/ECTA12679}.

Mele, A. (2017). A structural model of dense network formation. \emph{Econometrica}, 85(3), 825-850, \doi{10.3982/ECTA10400}.

Yan, T., Jiang, B., Fienberg, S. E., & Leng, C. (2019). Statistical inference in a directed network model with covariates. \emph{Journal of the American Statistical Association}, 114(526), 857-868, \doi{10.1080/01621459.2018.1448829}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ahoundetoungan/CDatanet}
  \item Report bugs at \url{https://github.com/ahoundetoungan/CDatanet/issues}
}

}
\author{
\strong{Maintainer}: Aristide Houndetoungan \email{ahoundetoungan@gmail.com}

}
