% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{insertTable}
\alias{insertTable}
\alias{insert_table}
\title{Add tables to a cdm object}
\usage{
insertTable(cdm, name, table)

insert_table(cdm, name, table)
}
\arguments{
\item{cdm}{A cdm reference}

\item{name}{A character name with the name of the table.}

\item{table}{Table to insert in the cdm object. It has to be a in R-memory
table.}
}
\value{
Returns the cdm object with the new tables added
}
\description{
Add tables to a cdm object
}
\examples{
\dontrun{
library(CDMConnector)

con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomia_dir())
cdm <- cdm_from_con(con, cdm_schema = "main", write_schema = "main")

cdm

new_table <- dplyr::tibble(a = 1)

cdm <- insertTable(cdm, "new_table", new_table)

cdm

cdm$new_table

cdm_disconnect(cdm)
}
}
