

######################################################################################
# This function calculates tetrachoric correlations among skills                    ##
# Input is an object generated by din function                                      ##
skill.cor <- function( object){
	options( warn=-1)
	# need polycor library
    library(polycor)
    ap <- object$attribute.patt
    aps <- object$attribute.patt.splitted
#    object$skill.patt
    # collect all skill combinations
    skill.combis <- t( combn( length(object$skill.patt ) , 2) )
    # create contingency tables
    skills.bivariate <- t( apply( skill.combis , 1 , FUN = function(ll){
                ss1 <- ll[1] ; ss2 <- ll[2]
                c(  "Freq00" = sum( ap[ aps[ , ss1 ] == 0 & aps[,ss2] == 0 , "class.prob" ] ) ,
                "Freq10" = sum( ap[ aps[ , ss1 ] == 1 & aps[,ss2] == 0 , "class.prob" ] ) ,
                "Freq01" = sum( ap[ aps[ , ss1 ] == 0 & aps[,ss2] == 1 , "class.prob" ] ) ,
                "Freq11" = sum( ap[ aps[ , ss1 ] == 1 & aps[,ss2] == 1 , "class.prob" ] ) )
                } ) )  		
    res <- data.frame( "skill1" = rownames(object$skill.patt)[ skill.combis[,1] ] , 
                "skill2" = rownames(object$skill.patt)[ skill.combis[,2] ] , 
                skill.combis ,   skills.bivariate )		
    for (vv in 3:8){ res[,vv] <- as.numeric( paste( res[,vv] ) ) }
    # calculate tetrachoric correlation
    res$tetracor <- apply( res[ , 5:8 ] , 1 , FUN = function(ll){
              polychor( matrix(as.numeric(ll),nrow=2) ) } )
    r2 <- res[ , c(2,1,4,3,5,7,6,8,9) ] 
    colnames(r2) <- colnames(res)
    res <- rbind( res , r2 )
    res <- res[ order( res[,3]*1000 + res[,4] ) , ]
    # create matrix of tetrachoric correlations
    K <- max( r2[,3] )
    skill.cors <- diag( 1 , K )
    rownames(skill.cors) <- colnames(skill.cors) <- rownames(object$skill.patt)
    for (ii in 1:K){ 
			skill.cors[ii,-ii] <- res[ res[,3] == ii , "tetracor"] 
							}
    res <- list( "conttable.skills" = res , "cor.skills" = skill.cors )
	options(warn=0)
    return(res) 
    }
######################################################################################
