% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupBycoord.R
\name{groupBycoord}
\alias{groupBycoord}
\title{Define groups of categories on the basis of a selected partition into k groups
employing the Jenks' natural break method on the selected dimension's
coordinates}
\usage{
groupBycoord(data, x = 1, k = 3, which = "rows", cex.labls = 0.75)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{x}{Dimension whose coordinates are used to build the partitions.}

\item{k}{Number of groups.}

\item{which}{Speficy if rows ("rows"; default) or columns ("cols") must be
grouped.}

\item{cex.labls}{Set the size of the labels of the dot chart (0.75 by default).}
}
\description{
The function allows to group the row/column categories into k user-defined
partitions.
}
\details{
K groups are created employing the Jenks' natural break method applied on the
selected dimension's coordinates. A dot chart is returned representing the
categories grouped into the selected partitions. At the bottom of the chart,
the Goodness of Fit statistic is also reported. The function also returns a
dataframe storing the categories' coordinates on the selected dimension and
the group each category belongs to.
}
\examples{
data(greenacre_data)

#divide the row categories into 3 groups on the basis of the coordinates
#of the 1st dimension, and store the result into a 'res' object
res <- groupBycoord(greenacre_data, x=1, k=3, which="rows")

}
\seealso{
\code{\link{caCluster}}
}
\keyword{groupBycoord}
