% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATTexact.R
\name{catt_asy}
\alias{catt_asy}
\title{Asymptotic Cochran-Armitage trend test}
\usage{
catt_asy(dose.ratings, totals, cases)
}
\arguments{
\item{dose.ratings}{A vector of dose ratings, the i-th entry corresponds to the dose-rating of the i-th group. This vector must be strictly monotonically increasing}

\item{totals}{The vector of total individuals per group, the i-th entry corresponds to the total number of individuals in the i-th group}

\item{cases}{The vector of incidences per groups, the i-th entry corresponds to the number of incidences in the i-th group}
}
\value{
A list containing the value of the Cochran-Armitage Trend Test Statistic and its asymptotic p-value.
}
\description{
\code{catt_asy} calculates the Cochran-Armitage trend test statistic (Cochran (1954), Armitage (1955)) and the one-sided p-value for the corresponding asymptotic test.
The exact form of used test statistic can be found in the paper by Portier and Hoel (1984).
}
\examples{
d <- c(1,2,3,4)
n <- rep(20,4)
r <- c(1,4,3,8)

catt_asy(d, n, r)

}
\references{
Armitage, P. Tests for linear trends in proportions and frequencies. \emph{Biometrics}, 11 (1955): 375-386.

Cochran, W. G. Some methods for strengthening the common \eqn{\chi^2} tests, \emph{Biometrics}. 10 (1954): 417-451.

Portier, C., and Hoel D. Type 1 error of trend tests in proportions and the design of cancer screens. \emph{Communications in Statistics-Theory and Methods}, 13 (1984): 1-14.
}
