% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_caiser.R
\name{summary.CAISEr}
\alias{summary.CAISEr}
\title{summary.CAISEr}
\usage{
\method{summary}{CAISEr}(object, test = NULL, alternative = NULL,
  sig.level = NULL, ...)
}
\arguments{
\item{object}{list object of class \emph{CAISEr}
(generated by \code{\link[=run_experiment]{run_experiment()}})}

\item{test}{type of test to be used
("t.test", "wilcoxon" or "binomial")}

\item{alternative}{type of alternative hypothesis ("two.sided" or
"less" or "greater"). See \code{\link[=calc_instances]{calc_instances()}} for details.}

\item{sig.level}{desired family-wise significance level (alpha) for the
experiment}

\item{...}{other parameters to be passed down to specific
summary functions (currently unused)}
}
\value{
A list object is returned invisibly, containing the details of all
tests performed as well as information on the total number of runs
dedicated to each algorithm.
}
\description{
S3 method for summarizing \emph{CAISEr} objects output by \code{\link[=run_experiment]{run_experiment()}}).
Input parameters \code{test}, \code{alternative} and \code{sig.level} can be used to
override the ones used in the call to \code{\link[=run_experiment]{run_experiment()}}.
}
\examples{
# Example using four dummy algorithms and 100 dummy instances.
# See [dummyalgo()] and [dummyinstance()] for details.
# Generating 4 dummy algorithms here, with means 15, 10, 30, 15 and standard
# deviations 2, 4, 6, 8.
algorithms <- mapply(FUN = function(i, m, s){
  list(FUN   = "dummyalgo",
       alias = paste0("algo", i),
       distribution.fun  = "rnorm",
       distribution.pars = list(mean = m, sd = s))},
  i = c(alg1 = 1, alg2 = 2, alg3 = 3, alg4 = 4),
  m = c(15, 10, 30, 15),
  s = c(2, 4, 6, 8),
  SIMPLIFY = FALSE)

# Generate 100 dummy instances with centered exponential distributions
instances <- lapply(1:100,
                    function(i) {rate <- runif(1, 1, 10)
                                 list(FUN   = "dummyinstance",
                                      alias = paste0("Inst.", i),
                                      distr = "rexp", rate = rate,
                                      bias  = -1 / rate)})

my.results <- run_experiment(instances, algorithms,
                             d = 1, se.max = .1,
                             power = .9, sig.level = .05,
                             power.target = "mean",
                             dif = "perc", comparisons = "all.vs.all",
                             seed = 1234, ncpus = 1)
summary(my.results)

# You can override some defaults if you want:
summary(my.results, test = "wilcoxon")

}
