#' summary.nreps
#'
#' S3 method for summarizing _nreps_ objects output by [calc_nreps()]).
#'
#' @param object list object of class _nreps_
#'                     (generated by [calc_nreps()])
#' @param ... other parameters to be passed down to specific
#'            summary functions (currently unused)
#'
#'
#' @method summary nreps
#'
#' @export
#'
summary.nreps <- function(object, ...)
{
  # Print summary
  cat("#====================================")
  cat("\nInstance:", object$instance)
  cat("\nNumber of algorithms:", length(object$Nk))
  for (i in seq_along(object$Nk)){
    cat(paste0("\n", names(object$Nk)[i], ": ", object$Nk[i], " runs"))
  }
  cat("\n --------------------")
  cat("\nTotal runs:", sum(object$Nk))
  cat("\nComparisons:", object$comparisons)
  cat("\n#====================================\n\n")
  print(signif(object$Diffk, 3))
  cat("\n#====================================")

}
