% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ropt.R
\name{calc_ropt}
\alias{calc_ropt}
\title{Calculates the optimal ratio of sample sizes}
\usage{
calc_ropt(x1, x2, dif)
}
\arguments{
\item{x1}{vector of observations}

\item{x2}{vector of observations}

\item{dif}{name of the difference for which the SE is desired. Accepts "perc"
(for percent differences) or "simple" (for simple differences)}
}
\value{
numeric value: optimal ratio n1 / n2
}
\description{
Calculates the optimal ratio of sample sizes of two algorithms on a given
instance, for either simple or percent differences, using the parametric
approach.
}
\section{References}{

\itemize{
\item F. Campelo, F. Takahashi:
Sample size estimation for power and accuracy in the experimental
comparison of algorithms (submitted, 2017).
}
}

\examples{
set.seed(1234)
x1 <- rnorm(25, 5, 1)
x2 <- runif(35, 8, 10)
calc_ropt(x1, x2, "simple")
calc_ropt(x1, x2, "perc")
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br})
}
