% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_caiser.R
\name{print.CAISEr}
\alias{print.CAISEr}
\title{print.CAISEr}
\usage{
\method{print}{CAISEr}(x, ..., digits = 6, right = TRUE,
  breakrows = FALSE)
}
\arguments{
\item{x}{list object of class \emph{CAISEr}
(generated by \code{\link[=run_experiment]{run_experiment()}})}

\item{...}{other parameters to be passed down to specific
summary functions (currently unused)}

\item{digits}{the minimum number of significant digits to be used.
See \code{\link[=print.default]{print.default()}}.}

\item{right}{logical, indicating whether or not strings should be
right-aligned.}

\item{breakrows}{logical, indicating whether to "widen" the output table by
placing the bottom half to the right of the top half.}
}
\description{
S3 method for printing \emph{CAISEr} objects (the output of
\code{\link[=run_experiment]{run_experiment()}}).
}
\examples{
# Example using dummy algorithms and instances. See ?dummyalgo for details.
# In this case all instances are the same, so we expect all cases to return
# a percent difference of approx. phi.j = 1.0 and sample sizes of
# approx. n1 = 31, n2 = 87
algorithm1 <- list(FUN = "dummyalgo", alias = "algo1",
                   distribution.fun = "rnorm",
                   distribution.pars = list(mean = 10, sd = 1))
algorithm2 <- list(FUN = "dummyalgo", alias = "algo2",
                   distribution.fun = "rnorm",
                   distribution.pars = list(mean = 20, sd = 4))
algolist <- list(algorithm1, algorithm2)
instlist <- vector(100, mode = "list")
for (i in 1:100) instlist[[i]] <- list(FUN = "dummyinstance",
                                       alias = paste0("Inst. ", i))

out <- run_experiment(Instance.list = instlist,
                      Algorithm.list = algolist,
                      power = 0.8,
                      d = 1,
                      sig.level = 0.01,
                      se.max = 0.05,
                      dif = "perc",
                      nmax   = 200,
                      seed   = 1234)
out

}
