/*
 * FactorSubsetPane.java
 *
 * Created on May 16, 2008, 12:28 AM
 */
package org.neptuneinc.cadstat.ui;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

/**
 *
 * @author  Pasha Minallah
 */
public class FactorSubsetPane extends JPanel
{
  private String dataset;

  /** Creates new form FactorSubsetPane */
  public FactorSubsetPane()
  {
    initComponents();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    factorLabel = new javax.swing.JLabel();
    factorComboBox = new javax.swing.JComboBox();
    factorValueScrollPane = new javax.swing.JScrollPane();
    factorValueList = new javax.swing.JList();

    factorLabel.setText("Factor:");

    factorComboBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        factorComboBoxActionPerformed(evt);
      }
    });

    factorValueScrollPane.setViewportView(factorValueList);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addComponent(factorLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(factorValueScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 175, Short.MAX_VALUE)
          .addComponent(factorComboBox, 0, 175, Short.MAX_VALUE)))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(factorLabel)
          .addComponent(factorComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(factorValueScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 111, Short.MAX_VALUE))
    );
  }// </editor-fold>//GEN-END:initComponents

private void factorComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_factorComboBoxActionPerformed
  this.refreshFactorValueList();
}//GEN-LAST:event_factorComboBoxActionPerformed
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JComboBox factorComboBox;
  private javax.swing.JLabel factorLabel;
  private javax.swing.JList factorValueList;
  private javax.swing.JScrollPane factorValueScrollPane;
  // End of variables declaration//GEN-END:variables

  public JComboBox getFactorComboBox()
  {
    return factorComboBox;
  }

  public void setFactorComboBox(JComboBox factorComboBox)
  {
    this.factorComboBox = factorComboBox;
  }

  public JLabel getFactorLabel()
  {
    return factorLabel;
  }

  public void setFactorLabel(JLabel factorLabel)
  {
    this.factorLabel = factorLabel;
  }

  public JList getFactorValueList()
  {
    return factorValueList;
  }

  public void setFactorValueList(JList factorValueList)
  {
    this.factorValueList = factorValueList;
  }

  public JScrollPane getFactorValueScrollPane()
  {
    return factorValueScrollPane;
  }

  public void setFactorValueScrollPane(JScrollPane factorValueScrollPane)
  {
    this.factorValueScrollPane = factorValueScrollPane;
  }

  public String getSelectedFactor()
  {
    return GUIUtils.getSelectedItem(this.getFactorComboBox());
  }

  public Object[] getSelectedFactorValues()
  {
    return GUIUtils.getSelectedValues(this.getFactorValueList());
  }

  public void refreshValidity()
  {
    factorLabel.setEnabled(factorComboBox.getItemCount() > 0);
    factorComboBox.setEnabled(factorComboBox.getItemCount() > 0);
    factorValueList.setEnabled(factorValueList.getModel().getSize() > 0);
  }

  public void refreshFactorComboBox()
  {
    if (this.getDataset() == null)
    {
      return;
    }

    Object selectedFactor = this.getFactorComboBox().getSelectedItem();
    Vector<String> datasetFactors = null;

    try
    {
      datasetFactors = RUtils.factors(dataset);
    }
    catch (REngineException ex)
    {
      Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
    }
    catch (REXPMismatchException ex)
    {
      Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
    }

    if (datasetFactors != null)
    {
      factorComboBox.setModel(new DefaultComboBoxModel(datasetFactors));

      if (factorComboBox.getItemCount() > 0)
      {
        if (selectedFactor != null)
        {
          factorComboBox.setSelectedItem(selectedFactor);
        }
        else
        {
          factorComboBox.setSelectedIndex(0);
        }
      }
    }
    else
    {
      factorComboBox.removeAllItems();
    }

    this.refreshValidity();
  }

  public void refreshFactorValueList()
  {
    if (this.getDataset() == null)
    {
      return;
    }

    if (factorComboBox.getItemCount() > 0 && factorComboBox.getSelectedIndex() != -1)
    {
      String column = this.getSelectedFactor();

      String cmd = "unique(" + this.getDataset() + "$" + column + ")";
      Vector uniqueValues = null;

      int[] selectedIndices = this.getFactorValueList().getSelectedIndices();

      try
      {
        uniqueValues = RUtils.evalAsVector(cmd);

        if (uniqueValues != null)
        {
          factorValueList.setListData(uniqueValues);
        }
        else
        {
          factorValueList.removeAll();
        }

        if (selectedIndices != null)
        {
          factorValueList.setSelectedIndices(selectedIndices);
        }
      }
      catch (REngineException ex)
      {
        Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
      }
      catch (REXPMismatchException ex)
      {
        Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
      }
    }
    else
    {
      factorValueList.setModel(new DefaultListModel());
    }

    this.refreshValidity();
  }

  public String getDataset()
  {
    return dataset;
  }

  public void setDataset(String dataset)
  {
    String prevDataset = this.dataset;
    this.dataset = dataset;

    this.refreshFactorComboBox();
    this.refreshFactorValueList();
  }
}
