% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance}
\alias{performance}
\title{Assess Performance of a Classifier (EXPERIMENTAL)}
\usage{
performance(
  object,
  data = NULL,
  newdata = NA,
  fold.size = 1/10,
  fold.number = 0,
  name.response = NULL,
  null = c(brier = NA, AUC = 0.5),
  conf.level = 0.95,
  transformation = TRUE,
  auc.type = "classical",
  simplify = TRUE,
  trace = TRUE
)
}
\arguments{
\item{object}{a \code{glm} or \code{range} object, or a list of such object.}

\item{data}{[data.frame] the training data.}

\item{newdata}{[data.frame] an external data used to assess the performance.}

\item{fold.size}{[double, >0] Either the size of the test dataset (when >1) or the fraction of the dataset (when <1) to be used for testing when using cross-validation.}

\item{fold.number}{[integer] When strictly positive, the number of fold used in the cross-validation. If 0 then no cross validation is performed.}

\item{name.response}{[character] The name of the response variable (i.e. the one containing the categories).}

\item{null}{[numeric vector of length 2] the right-hand side of the null hypothesis relative to each metric.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.}

\item{transformation}{[logical]  should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.}

\item{auc.type}{[character] should the auc be computed approximating the predicted probability by a dirac (\code{"classical"}, usual AUC formula)
or approximating the predicted probability by a normal distribution.}

\item{simplify}{[logical] Should the number of fold and the size of the fold used for the cross validation be removed from the output?}

\item{trace}{[logical] Should the execution of the function be traced.}
}
\description{
Assess the performance in term of AUC and brier score of one or several binary classifiers.
Currently limited to logistic regressions and random forest.
}
\examples{
## Simulate data
set.seed(10)
n <- 100
df.train <- data.frame(Y = rbinom(n, prob = 0.5, size = 1), X1 = rnorm(n), X2 = rnorm(n))
df.test <- data.frame(Y = rbinom(n, prob = 0.5, size = 1), X1 = rnorm(n), X2 = rnorm(n))

## fit logistic model
e.null <- glm(Y~1, data = df.train, family = binomial(link="logit"))
e.logit <- glm(Y~X1+X2, data = df.train, family = binomial(link="logit"))

## assess performance on the training set (biased)
## and external dataset
BuyseTest::performance(e.logit, newdata = df.test)
BuyseTest::performance(list(null = e.null, prop = e.logit), newdata = df.test)

## assess performance using cross validation
set.seed(10)
BuyseTest::performance(e.logit, fold.number = 10)
set.seed(10)
\dontrun{
BuyseTest::performance(list(null = e.null, prop = e.logit), fold.number = 10)
BuyseTest::performance(e.logit, fold.number = c(50,20,10))
}
}
