% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableImportance.boot.R
\name{VariableImportance.boot}
\alias{VariableImportance.boot}
\alias{VariableImportance.boot.BranchGLMVS}
\alias{VariableImportance.boot.BranchGLMVI}
\title{Performs Parametric Bootstrap for Modified Variable Importance}
\usage{
VariableImportance.boot(object, ...)

\method{VariableImportance.boot}{BranchGLMVS}(
  object,
  nboot = 100,
  parallel = FALSE,
  nthreads = 8,
  showprogress = TRUE,
  ...
)

\method{VariableImportance.boot}{BranchGLMVI}(
  object,
  nboot = 100,
  parallel = FALSE,
  nthreads = 8,
  showprogress = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{BranchGLMVS} or \code{BranchGLMVI} object.}

\item{...}{further arguments to \link{VariableImportance} when \code{object} is of
class \code{BranchGLMVS}.}

\item{nboot}{the number of bootstrap replications to perform.}

\item{parallel}{a logical value to indicate if parallelization should be used.}

\item{nthreads}{number of threads used with OpenMP, only used if \code{parallel = TRUE}.}

\item{showprogress}{a logical value to indicate if a progress bar should be displayed.}
}
\value{
a \code{BranchGLMVI.boot} object which is a list with the following components
\item{\code{summary}}{ a data.frame with the observed modified variable importance values and approximate p-values}
\item{\code{results}}{ a numeric matrix with the modified variable importance values for each set of bootstrap replications}
\item{\code{pvals}}{ a numeric vector with the approximate p-values based on modified variable importance}
\item{\code{nboot}}{ the number of bootstrap replications performed}
\item{\code{metric}}{ the metric used to calculate the modified variable importance values}
\item{\code{VI}}{ the supplied \code{BranchGLMVI} object}
}
\description{
Performs a version of the parametric bootstrap to create an
approximate null distribution for the modified variable importance
values in order to get approximate p-values.
}
\details{
This performs a version of the parametric bootstrap with the modified variable
importance values to generate approximate p-values for the sets of variables.
We are currently working on a paper that describes this function in further detail.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
showprogress = FALSE)

# Getting approximate null distributions
set.seed(40174)
myBoot <- VariableImportance.boot(VS, showprogress = FALSE)
myBoot

# Plotting histogram of results for second set of variables
hist(myBoot, which = 2)

# Plotting boxplots of results
oldmar <- par("mar")
par(mar = c(4, 6, 3, 1) + 0.1)
boxplot(myBoot, las = 1)
par(mar = oldmar)

}
\seealso{
\link{hist.BranchGLMVI.boot}, \link{boxplot.BranchGLMVI.boot}, \link{VariableImportance}
}
