% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMCIs.R
\name{plotCI}
\alias{plotCI}
\title{Plot Confidence Intervals}
\usage{
plotCI(
  CIs,
  points = NULL,
  ylab = "",
  las = 2,
  cex.y = 1,
  decreasing = FALSE,
  ...
)
}
\arguments{
\item{CIs}{a matrix of confidence intervals, must have either 2 rows or 2 columns.
The variable names displayed in the plot are taken from either the column names 
or row names of this.}

\item{points}{points to be plotted in the middle of the CIs, typically means or medians.
The default is to plot the midpoint of the intervals.}

\item{ylab}{axis label for y-axis.}

\item{las}{the style of the y-axis label, the default is horizontal, 
see more about this at \link{par}.}

\item{cex.y}{font size used for variable names on y-axis.}

\item{decreasing}{a logical value indicating if confidence intervals should be 
displayed in decreasing or increasing order according to points. Can use NA 
if no ordering is desired.}

\item{...}{further arguments passed to default plot method.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
Plot Confidence Intervals
}
\examples{
Data <- iris
### Fitting linear regression model
mymodel <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

### Getting confidence intervals
CIs <- confint.default(mymodel, level = 0.95)
xlim <- c(min(CIs), max(CIs))

### Plotting CIs
par(mar = c(5, 7, 3, 1) + 0.1)
plotCI(CIs, main = "95\% Confidence Intervals", xlim = xlim, cex.y = 0.9, 
xlab = "Beta Coefficients")
abline(v = 0)

}
