% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.est.R
\name{population.est}
\alias{population.est}
\title{Estimate population-level partial correlation coefficients}
\usage{
population.est(Z, alpha = 0.05, lambda = NULL, ind.ci = FALSE)
}
\arguments{
\item{Z}{is a \eqn{n*p*m} dimensional array, where \eqn{m} is number of subjects.}

\item{alpha}{significance level, default value is \code{0.05}.}

\item{lambda}{a penalty parameter used in lasso of order \code{sqrt(log(p)/n)}, if \code{NULL}, \code{2*sqrt(log(p)/n)} will be used.}

\item{ind.ci}{a logical indicating whether to compute \eqn{1-\alpha} confidence interval of each subject, default value is \code{FALSE}.}
}
\value{
A \code{popEst} class object containing two components.

\code{coef} a \eqn{p*p} partial correlation coefficients matrix.

\code{ind.est} a \eqn{m}-length list, containing estimates for each individuals.
}
\description{
Estimate population-level partial correlation coefficients in time series data.
And also return each individual-level coefficients.
\cr
\cr
}
\examples{
## Quick example for the individual-level estimates
data(popsimA)
pc = population.est(popsimA)        # estimating partial correlation coefficients

}
\references{
Qiu Y. and Zhou X. (2021).
Inference on multi-level partial correlations
based on multi-subject time series data,
\emph{Journal of the American Statistical Association}, 00, 1-15
}
