% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{TentativeRoughFix}
\alias{TentativeRoughFix}
\title{Rough fix of Tentative attributes}
\usage{
TentativeRoughFix(x, averageOver = Inf)
}
\arguments{
\item{x}{an object of a class Boruta.}

\item{averageOver}{Either number of last importance source runs to
average over or Inf for averaging over the whole Boruta run.}
}
\value{
A Boruta class object with modified \code{finalDecision} element.
Such object has few additional elements:
\item{originalDecision}{Original \code{finalDecision}.}
\item{averageOver}{Copy of \code{averageOver} parameter.}
}
\description{
In some circumstances (too short Boruta run, unfortunate mixing of shadow attributes, tricky dataset\ldots), Boruta can leave some attributes Tentative.
\code{TentativeRoughFix} performs a simplified, weaker test for judging such attributes.
}
\details{
Function claims as Confirmed those attributes that
have median importance higher than the median importance of
maximal shadow attribute, and the rest as Rejected.
Depending of the user choice, medians for the test
are count over last round, all rounds or N last
importance source runs.
}
\note{
This function should be used only when strict decision is
highly desired, because this test is much weaker than Boruta
and can lower the confidence of the final result.

\code{x} has to be made with \code{holdHistory} set to
\code{TRUE} for this code to run.
}
