\name{particle}
\alias{particle}

\title{Reading particle files}

\description{This interprets the .particle[i].[t].[rho].txt files generated by the mix
function and outputs a data.frame of sufficient statistics and
posterior predictive information. The demos illustrate how to use the
output for posterior inference.}

\usage{
particle(i, mixobj, t, rho=0)
}

\arguments{
  \item{i}{ Particle index. }
  \item{mixobj}{ Object returned by the \code{mix} function.}
  \item{t}{ Time index. }
  \item{rho}{ BAR process correlation parameter. }
}

\value{ Returns a \code{data.frame} with each row corresponding to a
  mixture component (first is the base distribution).  The first
  column, \code{n}, is the number of observations allocated to each
  mixture component, the next set of columns are sufficient
  statistics, column \code{p} is the predictive probability for each
  component, and the final columns are moments (and degrees of
  freedom) for the student-t and multinomial posterior predictive
  mixture densities.}

\references{ 
\emph{ An auto-regressive mixture model for dynamic spatial Poisson processes: 
Application to tracking the intensity of violent crime} (Taddy 2009), 

and other papers at \url{faculty.chicagobooth.edu/matt.taddy/research.} }

\author{ Matt Taddy, \email{matt.taddy@chicagobooth.edu} }

\seealso{ \code{mix} }
