% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/907-parGOSim.R
\name{parGOSim}
\alias{parGOSim}
\title{Protein/DNA Sequence Similarity Calculation based on Gene Ontology (GO) Similarity}
\usage{
parGOSim(golist, type = c("go", "gene"), ont = "MF",
  organism = "human", measure = "Resnik", combine = "BMA")
}
\arguments{
\item{golist}{A character vector, each component contains
a character vector of GO terms or one Entrez Gene ID.}

\item{type}{Input type of \code{golist}, \code{'go'} for GO Terms, \code{'gene'} for gene ID.}

\item{ont}{Default is \code{'MF'}, could be one of \code{'MF'}, \code{'BP'}, or \code{'CC'} subontologies.}

\item{organism}{Default is \code{'human'}, could be one of \code{'anopheles'}, \code{'arabidopsis'}, \code{'bovine'}, \code{'canine'},
\code{'chicken'}, \code{'chimp'}, \code{'coelicolor'}, \code{'ecolik12'},
\code{'ecsakai'}, \code{'fly'}, \code{'human'}, \code{'malaria'},
\code{'mouse'}, \code{'pig'}, \code{'rat'}, \code{'rhesus'},
\code{'worm'}, \code{'xenopus'}, \code{'yeast'} or \code{'zebrafish'}.}

\item{measure}{Default is \code{'Resnik'}, could be one of \code{'Resnik'}, \code{'Lin'}, \code{'Rel'}, \code{'Jiang'} or \code{'Wang'}.}

\item{combine}{Default is \code{'BMA'}, could be one of \code{'max'}, \code{'average'}, \code{'rcmax'} or \code{'BMA'}
for combining semantic similarity scores of multiple GO terms associated with protein.}
}
\value{
A \code{n} x \code{n} similarity matrix.
}
\description{
Protein/DNA Sequence Similarity Calculation based on Gene Ontology (GO) Similarity
}
\details{
This function calculates
protein/DNA sequence similarity based on Gene Ontology (GO) similarity.
}
\examples{
\donttest{
# Be careful when testing this since it involves GO similarity computation
# and might produce unpredictable results in some environments

require(GOSemSim)
require(org.Hs.eg.db)

# by GO Terms
go1 = c('GO:0005215', 'GO:0005488', 'GO:0005515', 'GO:0005625', 'GO:0005802', 'GO:0005905')  # AP4B1
go2 = c('GO:0005515', 'GO:0005634', 'GO:0005681', 'GO:0008380', 'GO:0031202')  # BCAS2
go3 = c('GO:0003735', 'GO:0005622', 'GO:0005840', 'GO:0006412')  # PDE4DIP
glist = list(go1, go2, go3)
gsimmat1 = parGOSim(glist, type = 'go', ont = 'CC')
print(gsimmat1)

# by Entrez gene id
genelist = list(c('150', '151', '152', '1814', '1815', '1816'))
gsimmat2 = parGOSim(genelist, type = 'gene')
print(gsimmat2)}
}
\seealso{
See \code{\link{twoGOSim}} for calculating the
GO semantic similarity between two groups of GO terms or two Entrez gene IDs.
See \code{\link{parSeqSim}} for paralleled protein/DNA similarity
calculation based on Smith-Waterman local alignment.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://nanx.me}>
}
\keyword{GO}
\keyword{Ontology}
\keyword{similarity}
