% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/477-extractDrugPubChem.R
\name{extrDrugPubChemComplete}
\alias{extrDrugPubChemComplete}
\title{Calculate the PubChem Molecular Fingerprints (in Complete Format)}
\usage{
extrDrugPubChemComplete(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule, 
the columns represent the fingerprints.
}
\description{
Calculate the PubChem Molecular Fingerprints (in Complete Format)
}
\details{
Calculate the 881 bit fingerprints defined by PubChem.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugPubChemComplete(mol)
dim(fp)

}
\seealso{
\link{extrDrugPubChem}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugPubChemComplete}
