% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/475-extractDrugMACCS.R
\name{extrDrugMACCS}
\alias{extrDrugMACCS}
\title{Calculate the MACCS Molecular Fingerprints (in Compact Format)}
\usage{
extrDrugMACCS(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A list, each component represents one of the molecules, each element 
in the component represents the index of which element in the fingerprint is 1.
Each component's name is the length of the fingerprints.
}
\description{
Calculate the MACCS Molecular Fingerprints (in Compact Format)
}
\details{
The popular 166 bit MACCS keys described by MDL.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugMACCS(mol)
head(fp)

}
\seealso{
\link{extrDrugMACCSComplete}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugMACCS}
