% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARSupportFunctions.R
\name{MultVarSim}
\alias{MultVarSim}
\title{Simulate a VAR}
\usage{
MultVarSim(k, A1, p, Sigma, T)
}
\arguments{
\item{k}{Number of Series}

\item{A1}{Either a \eqn{k \times k} coefficient matrix or a \eqn{kp \times kp} matrix created using \code{\link{VarptoVar1MC}}.}

\item{p}{Maximum Lag Order}

\item{Sigma}{Residual Covariance Matrix of dimension \eqn{k\times k}}

\item{T}{Number of simulations}
}
\value{
Returns a \eqn{T \times k} of realizations from a VAR.
}
\description{
Simulate a VAR
}
\examples{
k=3;p=6
B=matrix(0,nrow=k,ncol=p*k)
A1<- matrix(c(.4,-.02,.01,-.02,.3,.02,.01,.04,.3),ncol=3,nrow=3)
A2 <- matrix(c(.2,0,0,0,.3,0,0,0,.13),ncol=3,nrow=3)
B[,1:k]=A1
B[,(4*k+1):(5*k)]=A2
A <- VarptoVar1MC(B,p,k)
Y <-MultVarSim(k,A,p,.1*diag(k),100)
}
\references{
Lutkepohl, "A New Introduction to Multiple Time Series Analysis"
}
\seealso{
\code{\link{VarptoVar1MC}}
}
