% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{blockmult}
\alias{blockmult}
\title{Block matrix multiplication with Delayed Array Object}
\usage{
blockmult(
  a,
  b,
  block_size = NULL,
  paral = NULL,
  threads = NULL,
  bigmatrix = NULL,
  mixblock_size = NULL,
  outfile = NULL,
  onmemory = NULL
)
}
\arguments{
\item{a}{a double matrix.}

\item{b}{a double matrix.}

\item{block_size}{(optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)}

\item{paral, }{(optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation}

\item{threads}{(optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available}

\item{bigmatrix}{(optiona, default = 5000) maximum number of rows or columns to consider as big matrix and work with
hdf5 files, by default a matrix with more than 5000 rows or files is considered big matrix and computation is made in disk}

\item{mixblock_size}{(optiona, default = 128), only if we are working with big matrix and parallel computation = true. 
Block size for mixed computation in big matrix parallel. Size of the block to be used to perform parallelized memory 
memory of the block read from the disk being processed.}

\item{outfile}{(optional) file name to work with hdf5 if we are working with big matrix in disk.}

\item{onmemory}{(optional) if onmemory = TRUE the multiplication is forced to execute in memory}
}
\value{
A List with : 
\itemize{
  \item{"matrix"}{ Result matrix if execution has been performed in memory}
  \item{"filename"}{ HDF5 filename if execution has been performed in disk, HDF5 file contains : 
    \itemize{
      \item{"INPUT"}{hdf5 group with input matrix A and B}
      \item{"OUTPUT"}{hdf5 group with output matrix C}
    }with input and output matrix.
  }
}
}
\description{
This function performs a block matrix-matrix multiplication with numeric matrix or Delayed Arrays
}
\examples{

library(DelayedArray)

# with numeric matrix
m <- 500
k <- 1500
n <- 400
A <- matrix(rnorm(n*k), nrow=n, ncol=k)
B <- matrix(rnorm(n*k), nrow=k, ncol=n)

C <- blockmult(A,B,128, TRUE)

# with Delaeyd Array
AD <- DelayedArray(A)
BD <- DelayedArray(B)

CD <- blockmult(AD,BD,128, TRUE)

}
