% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_bdCCA.R
\name{bdCCA_hdf5}
\alias{bdCCA_hdf5}
\title{Canonical Correlation Analysis}
\usage{
bdCCA_hdf5(
  filename,
  X,
  Y,
  m = 10,
  bcenter = TRUE,
  bscale = FALSE,
  bycols = FALSE,
  overwriteResults = FALSE,
  keepInteResults = FALSE
)
}
\arguments{
\item{filename}{string file name where dataset to normalize is stored.}

\item{X}{Dataset, path inside the hdf5 data file.}

\item{Y}{Dataset, path inside the hdf5 data file.}

\item{m}{Integer, number of blocks in which we want to partition the matrix to perform the calculations.}

\item{bcenter, }{Boolean, if true, dataset is centered to perform calculus.}

\item{bscale, }{Boolean, if true, dataset is centered to perform calculus.}

\item{bycols, }{Boolean by default = true, true indicates that the imputation will be done by columns, otherwise, the imputation will be done by rows.}

\item{overwriteResults, }{Boolean, if true, datasets existing inside a file must be overwritten if we are using the same names.}

\item{keepInteResults, }{Boolean, if false, intermediate results will be removed.}
}
\value{
hdf5 data file with CCA results,
}
\description{
This function is an application of the BigDataStatMeth functions to generate new methods. This function perform a Canonical Correlation Analysis
from two matrices stored in hdf5 data file. This function applies matrix partitioning, merge bloks to create a full matrix, apply a function to different blocks, etc.
}
\examples{
   print ("Example in vignette")

}
