% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MCMC1}
\alias{MCMC1}
\title{MCMC algorithm to sample from bivariate probit with partial
observability}
\usage{
MCMC1(X1, X2, Z, beta1, beta2, rho, fixrho, S, beta0, B0inv, rho0, v0, nu,
  P, tauSq, seed)
}
\arguments{
\item{X1}{a matrix of covariates for the first equation}

\item{X2}{a matrix of covariates for the second equation}

\item{Z}{a matrix of response values}

\item{beta1}{a matrix of starting values for beta1}

\item{beta2}{a matrix of starting values for beta2}

\item{rho}{a numeric starting value for rho}

\item{fixrho}{a logical determining if rho is fixed}

\item{S}{a numeric for the number of MCMC iterations}

\item{beta0}{a matrix of the beta prior mean parameter}

\item{B0inv}{a matrix of the inverse of beta prior covariance parameter}

\item{rho0}{a numeric for the mu prior parameter for rho}

\item{v0}{a numeric for the Sigma prior parameter for rho}

\item{nu}{a numeric for MCMC tuning parameter 1}

\item{P}{a numeric for MCMC tuning parameter 2}

\item{tauSq}{a numeric for MCMC tuning parameter 3}

\item{seed}{a numeric seed for determining the random draw sequence}
}
\value{
a matrix of MCMC draws
}
\description{
MCMC1() produces MCMC draws from the posterior of the bivariate
probit with partial observability. It does not perform input validation. 
It is reccomended to use \code{BiProbitPartial} instead of this function.
\code{BiProbitPartial} performs input validation
and then calls this function if \code{philosophy == "bayesian"}.
}
