% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{string2mat}
\alias{string2mat}
\title{Deriving interactions matrix}
\usage{
string2mat(curnames, mapping, int)
}
\arguments{
\item{curnames}{character vector with gene names which will be used in \code{BiDAG} learning function}

\item{mapping}{data frame, representing a mapping between curnames and preferredNames used in interactions downloaded from STRING (\url{https://string-db.org/}); two columns are necessary 'queryItem' and 'preferredName'}

\item{int}{data frame, representing a interactions between genes/proteins downloaded from STRING (\url{https://string-db.org/}); two columns are necessary 'node1' and 'node2'}
}
\value{
square matrix, whose entries equal 1 is interactions between i and j is found in the interaction list and 0 otherwise
}
\description{
This transforms a list of possible interactions between proteins downloaded from STRING database
into a matrix which can be used for blacklisting/penalization in BiDAG.
}
\examples{
curnames<-colnames(kirp)
intmat<-string2mat(curnames,mapSTRING,intSTRING)
}
