% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\name{dataGUTS}
\alias{dataGUTS}
\title{Read and format the data for the BeeGUTS model}
\usage{
dataGUTS(
  file_location = NULL,
  test_type = NULL,
  bee_species = "Honey_Bee",
  NA_string = getOption("datatable.na.strings", "NA"),
  ...
)
}
\arguments{
\item{file_location}{List of Locations of text files containing each two datasets, one for the survival data,
and one for the concentration data. Both datasets must be included in the same file and contain the same number of column in the same order.
The following columns must be included in the survival dataset:
\itemize{
\item \code{Survival time \[d\]}: a vector of time in days
\item \code{Control} A vector of number of survivors for the control
\item \code{T1} - \code{Tn} A vector of number of survivors for the treatments
T1 to Tn, one column per treatment.
}
A line containing the \code{Concentration unit} must be included directly after the end of
the last row of the survival data.

The following columns must be included in the concentration dataset
\itemize{
\item \code{Concentration time \[d\]}: a vector of time in days.
\item \code{Control} A vector of concentrations for the control
\item \code{T1} - \code{Tn} A vector of concentration for the treatments
T1 to Tn, one column per treatment.
}
For the \code{Acute_Oral} and \code{Acute_Contact}, only the initial
exposure concentration at time 0 is required.

See detail section for example}

\item{test_type}{list of test types amongst "Acute_Oral", "Acute_Contact", and "Chronic_Oral"
this list must have the same length of the list of file locations}

\item{bee_species}{the bee type among "Honey_Bee", "Bumble_Bee", "Osmia_bicornis", and "User_Bee". If "User_Bee" is selected,
optional arguments to be passed to the concentration reconstruction need to be defined.}

\item{NA_string}{a character vector of strings which are to be interpreted as NA values}

\item{...}{Optional arguments to be passed to the concentration reconstruction (e.g.
\itemize{
\item \code{k_sr =} for the stomach release rate (d-1), default is 0.625 for Honey bee,
\item \code{k_ca =} contact availability rate (d-1), default is 0.4 for Honey bee), or
\item \code{cTime =} the duration of exposure in days for the acute oral tests, default is 0.25 d
\item \code{cstConcCal = } logical, recalculate concentration in the Chronic_Oral test from mg a.s./kg feed to Xg/bee (default is TRUE)
\item \code{f_rate = } numerical vector, feeding rate used in the concentration recalculation in the Chronic_Oral (default is 25 mg/bee/day for honey bee)
\item \code{targConc =} numerical scalar, target concentration unit in the recalculation in the Chronic_Oral, 1 for µg/bee, 2 for ng/bee, 3 for mg/bee (default is 1).
}}
}
\value{
An object of class \code{beeSurvData}, which is a list with the following information:
\item{nDatasets}{Number of files passed to the function}
\item{survData}{A table containing the survival data as entered by the user in the input file}
\item{survData_long}{A data frame containing the survival data in long format for model purposes}
\item{concData}{A table containing the concentration data as entered by the user in the input file}
\item{concData_long}{A data frame containing concentration data in long format}
\item{unitData}{A character vector containing the units of the data as entered in the line \code{Concentration unit}
of the input file}
\item{typeData}{A character vector containing the type of experiment}
\item{beeSpecies}{A character vector containing the type bee}
\item{concModel}{A data frame containing the concentration data as recalculated by the model}
\item{concModel_long}{A data frame containing the concentration data as recalculated by the model in a long format}
Each element of the list is itself a list to account for multiple files that can be passed as input.
}
\description{
Read data from a \code{text} or \code{csv} file and recalculate the
exposure profile depending on the type of experiment (acute oral, acute contact, chronic oral).
}
\details{
The filename must begin with name of the chemical substance being tested and
each word of the filename should be separated via an underscore '_'.

#' Example of formatting of the input file for a chronic oral study
\tabular{lllllll}{
Survival time [d] \tab	Control	\tab T1	\tab T2	\tab T3	\tab T4	\tab T5 \cr
0	\tab 120	\tab 120	\tab 120	\tab 120	\tab 120	\tab 120 \cr
1	\tab 120	\tab 118	\tab 117	\tab 112	\tab 115	\tab 94 \cr
2	\tab 120	\tab 118	\tab 115	\tab 112	\tab 98	\tab 88 \cr
3	\tab 120	\tab 118	\tab 114	\tab 106	\tab 83	\tab 27 \cr
4	\tab 119	\tab 118	\tab 113	\tab 103	\tab 67	\tab 9 \cr
5	\tab 119	\tab 118	\tab 112	\tab 100	\tab 43	\tab 3 \cr
Concentration unit: ug/bee/day \tab\tab\tab\tab\tab\tab \cr
Concentration time [d]	\tab Control	\tab T1	\tab T2	\tab T3	\tab T4	\tab T5 \cr
0	\tab 0	\tab 3	\tab 7	\tab 12	\tab 41	\tab 68 \cr
5	\tab 0	\tab 3	\tab 7	\tab 12	\tab 41	\tab 68
}
}
\examples{
\donttest{
file_location <- system.file("extdata", "betacyfluthrin_chronic_ug.txt", package = "BeeGUTS")
lsData <- dataGUTS(file_location = c(file_location),
                  test_type = c('Chronic_Oral'),
                  bee_species = "Honey_Bee",
                  cstConcCal = FALSE)
}
}
