% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beesChecklist.R
\name{beesChecklist}
\alias{beesChecklist}
\title{Download a country-level checklist of bees from Discover Life}
\usage{
beesChecklist(
  URL = "https://figshare.com/ndownloader/files/47092720",
  destfile = NULL,
  method = "auto",
  ...
)
}
\arguments{
\item{URL}{A character vector to the FigShare location of the dataset. The default will be to
the most-recent version.}

\item{destfile}{a character string (or vector, see the url argument) with the file path where
the downloaded file is to be saved. Tilde-expansion is performed. If NULL (default), then destfile
is set as \code{paste0(tempdir(), "/beesChecklist.Rda")} (normalizePath for Windows).}

\item{method}{The method to be used for downloading files. Current download methods are
"internal", "libcurl", "wget", "curl" and "wininet" (Windows only), and there is a value
"auto": see ‘Details’ and ‘Note’. The method can also be set through the option
"download.file.method": see options(). description}

\item{...}{Extra variables that can be passed to \code{\link[utils:download.file]{utils::download.file()}}}
}
\value{
A downloaded beesChecklist.Rda file in the outPath and the same tibble returned to
the environment.

**Column details **

\strong{validName} The valid scientificName as it should occur in the scientificName column.

\strong{DiscoverLife_name} The full country name as it occurs on Discover Life.

\strong{rNaturalEarth_name} Country name from rnaturalearth's name_long and type = "map_units".

\strong{shortName} A short version of the country name.

\strong{continent} The continent where that country is found.

\strong{DiscoverLife_ISO} The ISO country name as it occurs on Discover Life.

\strong{Alpha-2} Alpha-2 from rnaturalearth.

\strong{iso_a3_eh} iso_a3_eh from rnaturalearth.

\strong{official} Official country name = "yes" or only a Discover Life name = "no".

\strong{Source} A text strign denoting the source or author of the name-country pair.

\strong{matchCertainty} Quality of the name's match to the Discover Life checklist.

\strong{canonical} The valid species name without scientificNameAuthority.

\strong{canonical_withFlags} The validName without the scientificNameAuthority but with Discover Life flags.

\strong{family} Bee family.

\strong{subfamily} Bee subfamily.

\strong{genus} Bee genus.

\strong{subgenus} Bee subgenus.

\strong{infraspecies} Bee infraSpecificEpithet.

\strong{species} Bee specificEpithet.

\strong{scientificNameAuthorship} Bee scientificNameAuthorship.

\strong{taxon_rank} Rank of the taxon name.

\strong{Notes} Discover Life country name notes.
}
\description{
Download the table contains taxonomic and country information for the bees of the world based
on data collated on Discover Life. The data will be sourced from the BeeBDC article's
Figshare.

Note that sometimes the download might not work without restarting R. In this case, you could
alternatively download the dataset from the URL below and then read it in using
\code{base::readRDS("filePath.Rda")}.
}
\examples{
\dontrun{
beesChecklist <- BeeBDC::beesChecklist()
}
}
\references{
This dataset was created using the Discover Life checklist and taxonomy.
Dataset is from the publication:
Dorey, J.B., Fischer, E.E., Chesshire, P.R., Nava-Bolaños, A., O’Reilly, R.L., Bossert, S., Collins, S.M., Lichtenberg, E.M., Tucker, E., Smith-Pardo, A., Falcon-Brindis, A., Guevara, D.A., Ribeiro, B.R., de Pedro, D., Hung, J.K.-L., Parys, K.A., McCabe, L.M., Rogan, M.S., Minckley, R.L., Velzco, S.J.E., Griswold, T., Zarrillo, T.A., Jetz, W., Sica, Y.V., Orr, M.C., Guzman, L.M., Ascher, J., Hughes, A.C. & Cobb, N.S. (2023) A globally synthesised and flagged bee occurrence dataset and cleaning workflow. Scientific Data, 10, 1–17. https://www.doi.org/10.1038/S41597-023-02626-W
The checklist data are mostly compiled from Discover Life data, www.discoverlife.org:
Ascher, J.S. & Pickering, J. (2020) Discover Life bee species guide and world checklist (Hymenoptera: Apoidea: Anthophila). http://www.discoverlife.org/mp/20q?guide=Apoidea_species
}
\seealso{
\code{\link[=beesTaxonomy]{beesTaxonomy()}} for further context.
}
